package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRecordingConfigurationResponse(
    recordingConfiguration: Option[zio.aws.ivs.model.RecordingConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse = {
    import CreateRecordingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse
      .builder()
      .optionallyWith(
        recordingConfiguration.map(value => value.buildAwsValue())
      )(_.recordingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.CreateRecordingConfigurationResponse.ReadOnly =
    zio.aws.ivs.model.CreateRecordingConfigurationResponse.wrap(buildAwsValue())
}
object CreateRecordingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateRecordingConfigurationResponse =
      zio.aws.ivs.model.CreateRecordingConfigurationResponse(
        recordingConfiguration.map(value => value.asEditable)
      )
    def recordingConfiguration
        : Option[zio.aws.ivs.model.RecordingConfiguration.ReadOnly]
    def getRecordingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.RecordingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordingConfiguration",
      recordingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse
  ) extends zio.aws.ivs.model.CreateRecordingConfigurationResponse.ReadOnly {
    override val recordingConfiguration
        : Option[zio.aws.ivs.model.RecordingConfiguration.ReadOnly] = scala
      .Option(impl.recordingConfiguration())
      .map(value => zio.aws.ivs.model.RecordingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationResponse
  ): zio.aws.ivs.model.CreateRecordingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
