package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioConfiguration(
    channels: Option[Integer] = None,
    codec: Option[String] = None,
    sampleRate: Option[Integer] = None,
    targetBitrate: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.AudioConfiguration = {
    import AudioConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.AudioConfiguration
      .builder()
      .optionallyWith(
        channels.map(value => Integer.unwrap(value): java.lang.Long)
      )(_.channels)
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(
        sampleRate.map(value => Integer.unwrap(value): java.lang.Long)
      )(_.sampleRate)
      .optionallyWith(
        targetBitrate.map(value => Integer.unwrap(value): java.lang.Long)
      )(_.targetBitrate)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.AudioConfiguration.ReadOnly =
    zio.aws.ivs.model.AudioConfiguration.wrap(buildAwsValue())
}
object AudioConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.AudioConfiguration =
      zio.aws.ivs.model.AudioConfiguration(
        channels.map(value => value),
        codec.map(value => value),
        sampleRate.map(value => value),
        targetBitrate.map(value => value)
      )
    def channels: Option[Integer]
    def codec: Option[String]
    def sampleRate: Option[Integer]
    def targetBitrate: Option[Integer]
    def getChannels: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("channels", channels)
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getSampleRate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getTargetBitrate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetBitrate", targetBitrate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ) extends zio.aws.ivs.model.AudioConfiguration.ReadOnly {
    override val channels: Option[Integer] = scala
      .Option(impl.channels())
      .map(value => zio.aws.ivs.model.primitives.Integer(value))
    override val codec: Option[String] =
      scala.Option(impl.codec()).map(value => value: String)
    override val sampleRate: Option[Integer] = scala
      .Option(impl.sampleRate())
      .map(value => zio.aws.ivs.model.primitives.Integer(value))
    override val targetBitrate: Option[Integer] = scala
      .Option(impl.targetBitrate())
      .map(value => zio.aws.ivs.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ): zio.aws.ivs.model.AudioConfiguration.ReadOnly = new Wrapper(impl)
}
