package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateChannelResponse(
    channel: Option[zio.aws.ivs.model.Channel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.UpdateChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.UpdateChannelResponse.ReadOnly =
    zio.aws.ivs.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.UpdateChannelResponse = zio.aws.ivs.model
      .UpdateChannelResponse(channel.map(value => value.asEditable))
    def channel: Option[zio.aws.ivs.model.Channel.ReadOnly]
    def getChannel: ZIO[Any, AwsError, zio.aws.ivs.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelResponse
  ) extends zio.aws.ivs.model.UpdateChannelResponse.ReadOnly {
    override val channel: Option[zio.aws.ivs.model.Channel.ReadOnly] = scala
      .Option(impl.channel())
      .map(value => zio.aws.ivs.model.Channel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelResponse
  ): zio.aws.ivs.model.UpdateChannelResponse.ReadOnly = new Wrapper(impl)
}
