package zio.aws.ivs.model
import java.lang.Integer
import zio.aws.ivs.model.primitives.{
  PaginationToken,
  MaxStreamKeyResults,
  ChannelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamKeysRequest(
    channelArn: ChannelArn,
    maxResults: Option[MaxStreamKeyResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest = {
    import ListStreamKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxStreamKeyResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListStreamKeysRequest.ReadOnly =
    zio.aws.ivs.model.ListStreamKeysRequest.wrap(buildAwsValue())
}
object ListStreamKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListStreamKeysRequest =
      zio.aws.ivs.model.ListStreamKeysRequest(
        channelArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelArn: ChannelArn
    def maxResults: Option[MaxStreamKeyResults]
    def nextToken: Option[PaginationToken]
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getMaxResults: ZIO[Any, AwsError, MaxStreamKeyResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest
  ) extends zio.aws.ivs.model.ListStreamKeysRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val maxResults: Option[MaxStreamKeyResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ivs.model.primitives.MaxStreamKeyResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListStreamKeysRequest
  ): zio.aws.ivs.model.ListStreamKeysRequest.ReadOnly = new Wrapper(impl)
}
