package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStreamSessionResponse(
    streamSession: Option[zio.aws.ivs.model.StreamSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse = {
    import GetStreamSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse
      .builder()
      .optionallyWith(streamSession.map(value => value.buildAwsValue()))(
        _.streamSession
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly =
    zio.aws.ivs.model.GetStreamSessionResponse.wrap(buildAwsValue())
}
object GetStreamSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetStreamSessionResponse =
      zio.aws.ivs.model
        .GetStreamSessionResponse(streamSession.map(value => value.asEditable))
    def streamSession: Option[zio.aws.ivs.model.StreamSession.ReadOnly]
    def getStreamSession
        : ZIO[Any, AwsError, zio.aws.ivs.model.StreamSession.ReadOnly] =
      AwsError.unwrapOptionField("streamSession", streamSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse
  ) extends zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly {
    override val streamSession
        : Option[zio.aws.ivs.model.StreamSession.ReadOnly] = scala
      .Option(impl.streamSession())
      .map(value => zio.aws.ivs.model.StreamSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamSessionResponse
  ): zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly = new Wrapper(impl)
}
