package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{StreamId, ChannelArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStreamSessionRequest(
    channelArn: ChannelArn,
    streamId: Option[StreamId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest = {
    import GetStreamSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetStreamSessionRequest.ReadOnly =
    zio.aws.ivs.model.GetStreamSessionRequest.wrap(buildAwsValue())
}
object GetStreamSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetStreamSessionRequest =
      zio.aws.ivs.model
        .GetStreamSessionRequest(channelArn, streamId.map(value => value))
    def channelArn: ChannelArn
    def streamId: Option[StreamId]
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest
  ) extends zio.aws.ivs.model.GetStreamSessionRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.ivs.model.primitives.StreamId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamSessionRequest
  ): zio.aws.ivs.model.GetStreamSessionRequest.ReadOnly = new Wrapper(impl)
}
