package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{TagValue, TagKey, ChannelArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamKeyRequest(
    channelArn: ChannelArn,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest = {
    import CreateStreamKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.CreateStreamKeyRequest.ReadOnly =
    zio.aws.ivs.model.CreateStreamKeyRequest.wrap(buildAwsValue())
}
object CreateStreamKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateStreamKeyRequest = zio.aws.ivs.model
      .CreateStreamKeyRequest(channelArn, tags.map(value => value))
    def channelArn: ChannelArn
    def tags: Option[Map[TagKey, TagValue]]
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest
  ) extends zio.aws.ivs.model.CreateStreamKeyRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateStreamKeyRequest
  ): zio.aws.ivs.model.CreateStreamKeyRequest.ReadOnly = new Wrapper(impl)
}
