package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  ChannelRecordingConfigurationArn,
  ChannelName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    authorized: Option[Boolean] = None,
    latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] = None,
    name: Option[ChannelName] = None,
    recordingConfigurationArn: Option[ChannelRecordingConfigurationArn] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    `type`: Option[zio.aws.ivs.model.ChannelType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateChannelRequest
      .builder()
      .optionallyWith(authorized.map(value => value: java.lang.Boolean))(
        _.authorized
      )
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.CreateChannelRequest.ReadOnly =
    zio.aws.ivs.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateChannelRequest =
      zio.aws.ivs.model.CreateChannelRequest(
        authorized.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        recordingConfigurationArn.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def authorized: Option[Boolean]
    def latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Option[ChannelName]
    def recordingConfigurationArn: Option[ChannelRecordingConfigurationArn]
    def tags: Option[Map[TagKey, TagValue]]
    def `type`: Option[zio.aws.ivs.model.ChannelType]
    def getAuthorized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.ivs.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ) extends zio.aws.ivs.model.CreateChannelRequest.ReadOnly {
    override val authorized: Option[Boolean] =
      scala.Option(impl.authorized()).map(value => value: Boolean)
    override val latencyMode: Option[zio.aws.ivs.model.ChannelLatencyMode] =
      scala
        .Option(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Option[ChannelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val recordingConfigurationArn
        : Option[ChannelRecordingConfigurationArn] = scala
      .Option(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.ivs.model.ChannelType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ivs.model.ChannelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateChannelRequest
  ): zio.aws.ivs.model.CreateChannelRequest.ReadOnly = new Wrapper(impl)
}
