package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{TagValue, TagKey, ChannelArn, StreamKeyArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamKeySummary(
    arn: Option[StreamKeyArn] = None,
    channelArn: Option[ChannelArn] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StreamKeySummary = {
    import StreamKeySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamKeySummary
      .builder()
      .optionallyWith(
        arn.map(value => StreamKeyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamKeySummary.ReadOnly =
    zio.aws.ivs.model.StreamKeySummary.wrap(buildAwsValue())
}
object StreamKeySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.StreamKeySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamKeySummary =
      zio.aws.ivs.model.StreamKeySummary(
        arn.map(value => value),
        channelArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[StreamKeyArn]
    def channelArn: Option[ChannelArn]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, StreamKeyArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamKeySummary
  ) extends zio.aws.ivs.model.StreamKeySummary.ReadOnly {
    override val arn: Option[StreamKeyArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.StreamKeyArn(value))
    override val channelArn: Option[ChannelArn] = scala
      .Option(impl.channelArn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamKeySummary
  ): zio.aws.ivs.model.StreamKeySummary.ReadOnly = new Wrapper(impl)
}
