package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait StreamHealth {
  def unwrap: software.amazon.awssdk.services.ivs.model.StreamHealth
}
object StreamHealth {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.StreamHealth
  ): zio.aws.ivs.model.StreamHealth = value match {
    case software.amazon.awssdk.services.ivs.model.StreamHealth.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.StreamHealth.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.ivs.model.StreamHealth.STARVING =>
      val r = STARVING
      r
    case software.amazon.awssdk.services.ivs.model.StreamHealth.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.StreamHealth {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.StreamHealth =
      software.amazon.awssdk.services.ivs.model.StreamHealth.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.ivs.model.StreamHealth {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.StreamHealth =
      software.amazon.awssdk.services.ivs.model.StreamHealth.HEALTHY
  }
  case object STARVING extends zio.aws.ivs.model.StreamHealth {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.StreamHealth =
      software.amazon.awssdk.services.ivs.model.StreamHealth.STARVING
  }
  case object UNKNOWN extends zio.aws.ivs.model.StreamHealth {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.StreamHealth =
      software.amazon.awssdk.services.ivs.model.StreamHealth.UNKNOWN
  }
}
