package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.Time
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StreamEvent(
    eventTime: Option[Time] = None,
    name: Option[String] = None,
    `type`: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.StreamEvent = {
    import StreamEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamEvent
      .builder()
      .optionallyWith(eventTime.map(value => Time.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamEvent.ReadOnly =
    zio.aws.ivs.model.StreamEvent.wrap(buildAwsValue())
}
object StreamEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamEvent =
      zio.aws.ivs.model.StreamEvent(
        eventTime.map(value => value),
        name.map(value => value),
        `type`.map(value => value)
      )
    def eventTime: Option[Time]
    def name: Option[String]
    def `type`: Option[String]
    def getEventTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamEvent
  ) extends zio.aws.ivs.model.StreamEvent.ReadOnly {
    override val eventTime: Option[Time] = scala
      .Option(impl.eventTime())
      .map(value => zio.aws.ivs.model.primitives.Time(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamEvent
  ): zio.aws.ivs.model.StreamEvent.ReadOnly = new Wrapper(impl)
}
