package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  RecordingConfigurationName,
  RecordingConfigurationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordingConfigurationSummary(
    arn: RecordingConfigurationArn,
    destinationConfiguration: zio.aws.ivs.model.DestinationConfiguration,
    name: Option[RecordingConfigurationName] = None,
    state: zio.aws.ivs.model.RecordingConfigurationState,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary = {
    import RecordingConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary
      .builder()
      .arn(RecordingConfigurationArn.unwrap(arn): java.lang.String)
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          RecordingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .state(state.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly =
    zio.aws.ivs.model.RecordingConfigurationSummary.wrap(buildAwsValue())
}
object RecordingConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.RecordingConfigurationSummary =
      zio.aws.ivs.model.RecordingConfigurationSummary(
        arn,
        destinationConfiguration.asEditable,
        name.map(value => value),
        state,
        tags.map(value => value)
      )
    def arn: RecordingConfigurationArn
    def destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    def name: Option[RecordingConfigurationName]
    def state: zio.aws.ivs.model.RecordingConfigurationState
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, RecordingConfigurationArn] = ZIO.succeed(arn)
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
    def getName: ZIO[Any, AwsError, RecordingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, Nothing, zio.aws.ivs.model.RecordingConfigurationState] =
      ZIO.succeed(state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary
  ) extends zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly {
    override val arn: RecordingConfigurationArn =
      zio.aws.ivs.model.primitives.RecordingConfigurationArn(impl.arn())
    override val destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly =
      zio.aws.ivs.model.DestinationConfiguration
        .wrap(impl.destinationConfiguration())
    override val name: Option[RecordingConfigurationName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.ivs.model.primitives.RecordingConfigurationName(value)
      )
    override val state: zio.aws.ivs.model.RecordingConfigurationState =
      zio.aws.ivs.model.RecordingConfigurationState.wrap(impl.state())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary
  ): zio.aws.ivs.model.RecordingConfigurationSummary.ReadOnly = new Wrapper(
    impl
  )
}
