package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.RecordingConfigurationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRecordingConfigurationRequest(
    arn: RecordingConfigurationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest = {
    import DeleteRecordingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest
      .builder()
      .arn(RecordingConfigurationArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.DeleteRecordingConfigurationRequest.ReadOnly =
    zio.aws.ivs.model.DeleteRecordingConfigurationRequest.wrap(buildAwsValue())
}
object DeleteRecordingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.DeleteRecordingConfigurationRequest =
      zio.aws.ivs.model.DeleteRecordingConfigurationRequest(arn)
    def arn: RecordingConfigurationArn
    def getArn: ZIO[Any, Nothing, RecordingConfigurationArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest
  ) extends zio.aws.ivs.model.DeleteRecordingConfigurationRequest.ReadOnly {
    override val arn: RecordingConfigurationArn =
      zio.aws.ivs.model.primitives.RecordingConfigurationArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.DeleteRecordingConfigurationRequest
  ): zio.aws.ivs.model.DeleteRecordingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
