package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  RecordingConfigurationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRecordingConfigurationRequest(
    destinationConfiguration: zio.aws.ivs.model.DestinationConfiguration,
    name: Option[RecordingConfigurationName] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest = {
    import CreateRecordingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
      .builder()
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          RecordingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly =
    zio.aws.ivs.model.CreateRecordingConfigurationRequest.wrap(buildAwsValue())
}
object CreateRecordingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateRecordingConfigurationRequest =
      zio.aws.ivs.model.CreateRecordingConfigurationRequest(
        destinationConfiguration.asEditable,
        name.map(value => value),
        tags.map(value => value)
      )
    def destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    def name: Option[RecordingConfigurationName]
    def tags: Option[Map[TagKey, TagValue]]
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
    def getName: ZIO[Any, AwsError, RecordingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ) extends zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly {
    override val destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly =
      zio.aws.ivs.model.DestinationConfiguration
        .wrap(impl.destinationConfiguration())
    override val name: Option[RecordingConfigurationName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.ivs.model.primitives.RecordingConfigurationName(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ): zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
