package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessDeviceEvent {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent
}
object WirelessDeviceEvent {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent
  ): zio.aws.iotwireless.model.WirelessDeviceEvent = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.JOIN =>
      val r = Join
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.REJOIN =>
      val r = Rejoin
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.UPLINK_DATA =>
      val r = Uplink_Data
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.DOWNLINK_DATA =>
      val r = Downlink_Data
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.REGISTRATION =>
      val r = Registration
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object Join extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.JOIN
  }
  case object Rejoin extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.REJOIN
  }
  case object Uplink_Data
      extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.UPLINK_DATA
  }
  case object Downlink_Data
      extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.DOWNLINK_DATA
  }
  case object Registration
      extends zio.aws.iotwireless.model.WirelessDeviceEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceEvent.REGISTRATION
  }
}
