package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ImportTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateWirelessDeviceImportTaskRequest(
    id: ImportTaskId,
    sidewalk: zio.aws.iotwireless.model.SidewalkUpdateImportInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest = {
    import UpdateWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest
      .builder()
      .id(ImportTaskId.unwrap(id): java.lang.String)
      .sidewalk(sidewalk.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object UpdateWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model
        .UpdateWirelessDeviceImportTaskRequest(id, sidewalk.asEditable)
    def id: ImportTaskId
    def sidewalk: zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly
    def getId: ZIO[Any, Nothing, ImportTaskId] = ZIO.succeed(id)
    def getSidewalk: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly
    ] = ZIO.succeed(sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.UpdateWirelessDeviceImportTaskRequest.ReadOnly {
    override val id: ImportTaskId =
      zio.aws.iotwireless.model.primitives.ImportTaskId(impl.id())
    override val sidewalk
        : zio.aws.iotwireless.model.SidewalkUpdateImportInfo.ReadOnly =
      zio.aws.iotwireless.model.SidewalkUpdateImportInfo.wrap(impl.sidewalk())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.UpdateWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
