package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Result
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestWirelessDeviceResponse(
    result: Optional[Result] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse = {
    import TestWirelessDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse
      .builder()
      .optionallyWith(
        result.map(value => Result.unwrap(value): java.lang.String)
      )(_.result)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly =
    zio.aws.iotwireless.model.TestWirelessDeviceResponse.wrap(buildAwsValue())
}
object TestWirelessDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TestWirelessDeviceResponse =
      zio.aws.iotwireless.model
        .TestWirelessDeviceResponse(result.map(value => value))
    def result: Optional[Result]
    def getResult: ZIO[Any, AwsError, Result] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse
  ) extends zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly {
    override val result: Optional[Result] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => zio.aws.iotwireless.model.primitives.Result(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceResponse
  ): zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly =
    new Wrapper(impl)
}
