package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessDeviceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestWirelessDeviceRequest(id: WirelessDeviceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest = {
    import TestWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.TestWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.TestWirelessDeviceRequest.wrap(buildAwsValue())
}
object TestWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.TestWirelessDeviceRequest =
      zio.aws.iotwireless.model.TestWirelessDeviceRequest(id)
    def id: WirelessDeviceId
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.TestWirelessDeviceRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.TestWirelessDeviceRequest
  ): zio.aws.iotwireless.model.TestWirelessDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
