package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait SupportedRfRegion {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion
}
object SupportedRfRegion {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion
  ): zio.aws.iotwireless.model.SupportedRfRegion = value match {
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU868 =>
      val r = EU868
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.US915 =>
      val r = US915
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AU915 =>
      val r = AU915
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_1 =>
      val r = `AS923-1`
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_2 =>
      val r = `AS923-2`
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_3 =>
      val r = `AS923-3`
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_4 =>
      val r = `AS923-4`
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU433 =>
      val r = EU433
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.CN470 =>
      val r = CN470
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.CN779 =>
      val r = CN779
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.RU864 =>
      val r = RU864
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.KR920 =>
      val r = KR920
      r
    case software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.IN865 =>
      val r = IN865
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object EU868 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU868
  }
  case object US915 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.US915
  }
  case object AU915 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AU915
  }
  case object `AS923-1` extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_1
  }
  case object `AS923-2` extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_2
  }
  case object `AS923-3` extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_3
  }
  case object `AS923-4` extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.AS923_4
  }
  case object EU433 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.EU433
  }
  case object CN470 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.CN470
  }
  case object CN779 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.CN779
  }
  case object RU864 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.RU864
  }
  case object KR920 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.KR920
  }
  case object IN865 extends zio.aws.iotwireless.model.SupportedRfRegion {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion =
      software.amazon.awssdk.services.iotwireless.model.SupportedRfRegion.IN865
  }
}
