package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartWirelessDeviceImportTaskRequest(
    destinationName: DestinationName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    sidewalk: zio.aws.iotwireless.model.SidewalkStartImportInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest = {
    import StartWirelessDeviceImportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest
      .builder()
      .destinationName(
        DestinationName.unwrap(destinationName): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .sidewalk(sidewalk.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest
      .wrap(buildAwsValue())
}
object StartWirelessDeviceImportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest =
      zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest(
        destinationName,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sidewalk.asEditable
      )
    def destinationName: DestinationName
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def sidewalk: zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly
    def getDestinationName: ZIO[Any, Nothing, DestinationName] =
      ZIO.succeed(destinationName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSidewalk: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly
    ] = ZIO.succeed(sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest
  ) extends zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest.ReadOnly {
    override val destinationName: DestinationName =
      zio.aws.iotwireless.model.primitives
        .DestinationName(impl.destinationName())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val sidewalk
        : zio.aws.iotwireless.model.SidewalkStartImportInfo.ReadOnly =
      zio.aws.iotwireless.model.SidewalkStartImportInfo.wrap(impl.sidewalk())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartWirelessDeviceImportTaskRequest
  ): zio.aws.iotwireless.model.StartWirelessDeviceImportTaskRequest.ReadOnly =
    new Wrapper(impl)
}
