package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ServiceProfileId,
  ServiceProfileName,
  ServiceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceProfile(
    arn: Optional[ServiceProfileArn] = Optional.Absent,
    name: Optional[ServiceProfileName] = Optional.Absent,
    id: Optional[ServiceProfileId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ServiceProfile = {
    import ServiceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ServiceProfile
      .builder()
      .optionallyWith(
        arn.map(value => ServiceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ServiceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => ServiceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ServiceProfile.ReadOnly =
    zio.aws.iotwireless.model.ServiceProfile.wrap(buildAwsValue())
}
object ServiceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ServiceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ServiceProfile =
      zio.aws.iotwireless.model.ServiceProfile(
        arn.map(value => value),
        name.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[ServiceProfileArn]
    def name: Optional[ServiceProfileName]
    def id: Optional[ServiceProfileId]
    def getArn: ZIO[Any, AwsError, ServiceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ServiceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ServiceProfile
  ) extends zio.aws.iotwireless.model.ServiceProfile.ReadOnly {
    override val arn: Optional[ServiceProfileArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileArn(value)
      )
    override val name: Optional[ServiceProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileName(value)
      )
    override val id: Optional[ServiceProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ServiceProfile
  ): zio.aws.iotwireless.model.ServiceProfile.ReadOnly = new Wrapper(impl)
}
