package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ResourceType, ResourceIdentifier}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutResourceLogLevelRequest(
    resourceIdentifier: ResourceIdentifier,
    resourceType: ResourceType,
    logLevel: zio.aws.iotwireless.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest = {
    import PutResourceLogLevelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest
      .builder()
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.PutResourceLogLevelRequest.ReadOnly =
    zio.aws.iotwireless.model.PutResourceLogLevelRequest.wrap(buildAwsValue())
}
object PutResourceLogLevelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.PutResourceLogLevelRequest =
      zio.aws.iotwireless.model
        .PutResourceLogLevelRequest(resourceIdentifier, resourceType, logLevel)
    def resourceIdentifier: ResourceIdentifier
    def resourceType: ResourceType
    def logLevel: zio.aws.iotwireless.model.LogLevel
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iotwireless.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest
  ) extends zio.aws.iotwireless.model.PutResourceLogLevelRequest.ReadOnly {
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: ResourceType =
      zio.aws.iotwireless.model.primitives.ResourceType(impl.resourceType())
    override val logLevel: zio.aws.iotwireless.model.LogLevel =
      zio.aws.iotwireless.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.PutResourceLogLevelRequest
  ): zio.aws.iotwireless.model.PutResourceLogLevelRequest.ReadOnly =
    new Wrapper(impl)
}
