package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  CreationTime,
  ImportTaskId,
  ImportTaskArn,
  StatusReason,
  ImportedWirelessDeviceCount,
  DestinationName
}
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceImportTaskResponse(
    id: Optional[ImportTaskId] = Optional.Absent,
    arn: Optional[ImportTaskArn] = Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkGetStartImportInfo] =
      Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.ImportTaskStatus] =
      Optional.Absent,
    statusReason: Optional[StatusReason] = Optional.Absent,
    initializedImportedDeviceCount: Optional[ImportedWirelessDeviceCount] =
      Optional.Absent,
    pendingImportedDeviceCount: Optional[ImportedWirelessDeviceCount] =
      Optional.Absent,
    onboardedImportedDeviceCount: Optional[ImportedWirelessDeviceCount] =
      Optional.Absent,
    failedImportedDeviceCount: Optional[ImportedWirelessDeviceCount] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse = {
    import GetWirelessDeviceImportTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse
      .builder()
      .optionallyWith(
        id.map(value => ImportTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ImportTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        initializedImportedDeviceCount.map(value =>
          ImportedWirelessDeviceCount.unwrap(value): java.lang.Long
        )
      )(_.initializedImportedDeviceCount)
      .optionallyWith(
        pendingImportedDeviceCount.map(value =>
          ImportedWirelessDeviceCount.unwrap(value): java.lang.Long
        )
      )(_.pendingImportedDeviceCount)
      .optionallyWith(
        onboardedImportedDeviceCount.map(value =>
          ImportedWirelessDeviceCount.unwrap(value): java.lang.Long
        )
      )(_.onboardedImportedDeviceCount)
      .optionallyWith(
        failedImportedDeviceCount.map(value =>
          ImportedWirelessDeviceCount.unwrap(value): java.lang.Long
        )
      )(_.failedImportedDeviceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse
      .wrap(buildAwsValue())
}
object GetWirelessDeviceImportTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse =
      zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse(
        id.map(value => value),
        arn.map(value => value),
        destinationName.map(value => value),
        sidewalk.map(value => value.asEditable),
        creationTime.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        initializedImportedDeviceCount.map(value => value),
        pendingImportedDeviceCount.map(value => value),
        onboardedImportedDeviceCount.map(value => value),
        failedImportedDeviceCount.map(value => value)
      )
    def id: Optional[ImportTaskId]
    def arn: Optional[ImportTaskArn]
    def destinationName: Optional[DestinationName]
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly
    ]
    def creationTime: Optional[CreationTime]
    def status: Optional[zio.aws.iotwireless.model.ImportTaskStatus]
    def statusReason: Optional[StatusReason]
    def initializedImportedDeviceCount: Optional[ImportedWirelessDeviceCount]
    def pendingImportedDeviceCount: Optional[ImportedWirelessDeviceCount]
    def onboardedImportedDeviceCount: Optional[ImportedWirelessDeviceCount]
    def failedImportedDeviceCount: Optional[ImportedWirelessDeviceCount]
    def getId: ZIO[Any, AwsError, ImportTaskId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ImportTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.ImportTaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getInitializedImportedDeviceCount
        : ZIO[Any, AwsError, ImportedWirelessDeviceCount] =
      AwsError.unwrapOptionField(
        "initializedImportedDeviceCount",
        initializedImportedDeviceCount
      )
    def getPendingImportedDeviceCount
        : ZIO[Any, AwsError, ImportedWirelessDeviceCount] =
      AwsError.unwrapOptionField(
        "pendingImportedDeviceCount",
        pendingImportedDeviceCount
      )
    def getOnboardedImportedDeviceCount
        : ZIO[Any, AwsError, ImportedWirelessDeviceCount] =
      AwsError.unwrapOptionField(
        "onboardedImportedDeviceCount",
        onboardedImportedDeviceCount
      )
    def getFailedImportedDeviceCount
        : ZIO[Any, AwsError, ImportedWirelessDeviceCount] = AwsError
      .unwrapOptionField("failedImportedDeviceCount", failedImportedDeviceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse.ReadOnly {
    override val id: Optional[ImportTaskId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.ImportTaskId(value))
    override val arn: Optional[ImportTaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.ImportTaskArn(value))
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkGetStartImportInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkGetStartImportInfo.wrap(value)
      )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotwireless.model.primitives.CreationTime(value))
    override val status: Optional[zio.aws.iotwireless.model.ImportTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotwireless.model.ImportTaskStatus.wrap(value))
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.iotwireless.model.primitives.StatusReason(value))
    override val initializedImportedDeviceCount
        : Optional[ImportedWirelessDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.initializedImportedDeviceCount())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ImportedWirelessDeviceCount(value)
      )
    override val pendingImportedDeviceCount
        : Optional[ImportedWirelessDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingImportedDeviceCount())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ImportedWirelessDeviceCount(value)
      )
    override val onboardedImportedDeviceCount
        : Optional[ImportedWirelessDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.onboardedImportedDeviceCount())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ImportedWirelessDeviceCount(value)
      )
    override val failedImportedDeviceCount
        : Optional[ImportedWirelessDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failedImportedDeviceCount())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ImportedWirelessDeviceCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceImportTaskResponse
  ): zio.aws.iotwireless.model.GetWirelessDeviceImportTaskResponse.ReadOnly =
    new Wrapper(impl)
}
