package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  MulticastGroupStatus,
  CreatedAt,
  MulticastGroupArn,
  MulticastGroupId,
  Description,
  MulticastGroupName
}
import scala.jdk.CollectionConverters._
final case class GetMulticastGroupResponse(
    arn: Optional[MulticastGroupArn] = Optional.Absent,
    id: Optional[MulticastGroupId] = Optional.Absent,
    name: Optional[MulticastGroupName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[MulticastGroupStatus] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANMulticastGet] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse = {
    import GetMulticastGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => MulticastGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => MulticastGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => MulticastGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        status.map(value =>
          MulticastGroupStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly =
    zio.aws.iotwireless.model.GetMulticastGroupResponse.wrap(buildAwsValue())
}
object GetMulticastGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetMulticastGroupResponse =
      zio.aws.iotwireless.model.GetMulticastGroupResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        loRaWAN.map(value => value.asEditable),
        createdAt.map(value => value)
      )
    def arn: Optional[MulticastGroupArn]
    def id: Optional[MulticastGroupId]
    def name: Optional[MulticastGroupName]
    def description: Optional[Description]
    def status: Optional[MulticastGroupStatus]
    def loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly]
    def createdAt: Optional[CreatedAt]
    def getArn: ZIO[Any, AwsError, MulticastGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, MulticastGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, MulticastGroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse
  ) extends zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly {
    override val arn: Optional[MulticastGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupArn(value)
      )
    override val id: Optional[MulticastGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
      )
    override val name: Optional[MulticastGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val status: Optional[MulticastGroupStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupStatus(value)
      )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANMulticastGet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANMulticastGet.wrap(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotwireless.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupResponse
  ): zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
