package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEventConfigurationByResourceTypesResponse(
    deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
    ] = Optional.Absent,
    proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration
    ] = Optional.Absent,
    join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration
    ] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
    ] = Optional.Absent,
    messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse = {
    import GetEventConfigurationByResourceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
      .builder()
      .optionallyWith(
        deviceRegistrationState.map(value => value.buildAwsValue())
      )(_.deviceRegistrationState)
      .optionallyWith(proximity.map(value => value.buildAwsValue()))(
        _.proximity
      )
      .optionallyWith(join.map(value => value.buildAwsValue()))(_.join)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .optionallyWith(
        messageDeliveryStatus.map(value => value.buildAwsValue())
      )(_.messageDeliveryStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse.ReadOnly =
    zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse
      .wrap(buildAwsValue())
}
object GetEventConfigurationByResourceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse =
      zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse(
        deviceRegistrationState.map(value => value.asEditable),
        proximity.map(value => value.asEditable),
        join.map(value => value.asEditable),
        connectionStatus.map(value => value.asEditable),
        messageDeliveryStatus.map(value => value.asEditable)
      )
    def deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ]
    def proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ]
    def join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ]
    def connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ]
    def messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly
    ]
    def getDeviceRegistrationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceRegistrationState",
      deviceRegistrationState
    )
    def getProximity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("proximity", proximity)
    def getJoin: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("join", join)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getMessageDeliveryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("messageDeliveryStatus", messageDeliveryStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
  ) extends zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse.ReadOnly {
    override val deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRegistrationState())
      .map(value =>
        zio.aws.iotwireless.model.DeviceRegistrationStateResourceTypeEventConfiguration
          .wrap(value)
      )
    override val proximity: Optional[
      zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proximity())
      .map(value =>
        zio.aws.iotwireless.model.ProximityResourceTypeEventConfiguration
          .wrap(value)
      )
    override val join: Optional[
      zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.join())
      .map(value =>
        zio.aws.iotwireless.model.JoinResourceTypeEventConfiguration.wrap(value)
      )
    override val connectionStatus: Optional[
      zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionStatus())
      .map(value =>
        zio.aws.iotwireless.model.ConnectionStatusResourceTypeEventConfiguration
          .wrap(value)
      )
    override val messageDeliveryStatus: Optional[
      zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageDeliveryStatus())
      .map(value =>
        zio.aws.iotwireless.model.MessageDeliveryStatusResourceTypeEventConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetEventConfigurationByResourceTypesResponse
  ): zio.aws.iotwireless.model.GetEventConfigurationByResourceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
