package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DeviceProfileId,
  DeviceProfileName,
  DeviceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeviceProfileResponse(
    arn: Optional[DeviceProfileArn] = Optional.Absent,
    name: Optional[DeviceProfileName] = Optional.Absent,
    id: Optional[DeviceProfileId] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile] =
      Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkGetDeviceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse = {
    import GetDeviceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
      .builder()
      .optionallyWith(
        arn.map(value => DeviceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DeviceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => DeviceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly =
    zio.aws.iotwireless.model.GetDeviceProfileResponse.wrap(buildAwsValue())
}
object GetDeviceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetDeviceProfileResponse =
      zio.aws.iotwireless.model.GetDeviceProfileResponse(
        arn.map(value => value),
        name.map(value => value),
        id.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable)
      )
    def arn: Optional[DeviceProfileArn]
    def name: Optional[DeviceProfileName]
    def id: Optional[DeviceProfileId]
    def loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly]
    def sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly]
    def getArn: ZIO[Any, AwsError, DeviceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DeviceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ) extends zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly {
    override val arn: Optional[DeviceProfileArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileArn(value)
      )
    override val name: Optional[DeviceProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileName(value)
      )
    override val id: Optional[DeviceProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(value)
        )
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkGetDeviceProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkGetDeviceProfile.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileResponse
  ): zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
