package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DeviceProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDeviceProfileRequest(id: DeviceProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest = {
    import GetDeviceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest
      .builder()
      .id(DeviceProfileId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetDeviceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.GetDeviceProfileRequest.wrap(buildAwsValue())
}
object GetDeviceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetDeviceProfileRequest =
      zio.aws.iotwireless.model.GetDeviceProfileRequest(id)
    def id: DeviceProfileId
    def getId: ZIO[Any, Nothing, DeviceProfileId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest
  ) extends zio.aws.iotwireless.model.GetDeviceProfileRequest.ReadOnly {
    override val id: DeviceProfileId =
      zio.aws.iotwireless.model.primitives.DeviceProfileId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDeviceProfileRequest
  ): zio.aws.iotwireless.model.GetDeviceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
