package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DestinationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDestinationRequest(name: DestinationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest = {
    import GetDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest
      .builder()
      .name(DestinationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetDestinationRequest.ReadOnly =
    zio.aws.iotwireless.model.GetDestinationRequest.wrap(buildAwsValue())
}
object GetDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetDestinationRequest =
      zio.aws.iotwireless.model.GetDestinationRequest(name)
    def name: DestinationName
    def getName: ZIO[Any, Nothing, DestinationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest
  ) extends zio.aws.iotwireless.model.GetDestinationRequest.ReadOnly {
    override val name: DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetDestinationRequest
  ): zio.aws.iotwireless.model.GetDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
