package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWirelessGatewayTaskRequest(id: WirelessGatewayId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest = {
    import DeleteWirelessGatewayTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest
      .wrap(buildAwsValue())
}
object DeleteWirelessGatewayTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest =
      zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest(id)
    def id: WirelessGatewayId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest
  ) extends zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayTaskRequest
  ): zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest.ReadOnly =
    new Wrapper(impl)
}
