package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  NetworkAnalyzerConfigurationName,
  NetworkAnalyzerConfigurationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkAnalyzerConfigurationResponse(
    arn: Optional[NetworkAnalyzerConfigurationArn] = Optional.Absent,
    name: Optional[NetworkAnalyzerConfigurationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse = {
    import CreateNetworkAnalyzerConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          NetworkAnalyzerConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        name.map(value =>
          NetworkAnalyzerConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateNetworkAnalyzerConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse =
      zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[NetworkAnalyzerConfigurationArn]
    def name: Optional[NetworkAnalyzerConfigurationName]
    def getArn: ZIO[Any, AwsError, NetworkAnalyzerConfigurationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NetworkAnalyzerConfigurationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
  ) extends zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse.ReadOnly {
    override val arn: Optional[NetworkAnalyzerConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.arn())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .NetworkAnalyzerConfigurationArn(value)
        )
    override val name: Optional[NetworkAnalyzerConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.iotwireless.model.primitives
            .NetworkAnalyzerConfigurationName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse
  ): zio.aws.iotwireless.model.CreateNetworkAnalyzerConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
