package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  MulticastGroupId,
  MulticastGroupArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMulticastGroupResponse(
    arn: Optional[MulticastGroupArn] = Optional.Absent,
    id: Optional[MulticastGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse = {
    import CreateMulticastGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse
      .builder()
      .optionallyWith(
        arn.map(value => MulticastGroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => MulticastGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateMulticastGroupResponse.wrap(buildAwsValue())
}
object CreateMulticastGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateMulticastGroupResponse =
      zio.aws.iotwireless.model.CreateMulticastGroupResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[MulticastGroupArn]
    def id: Optional[MulticastGroupId]
    def getArn: ZIO[Any, AwsError, MulticastGroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, MulticastGroupId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse
  ) extends zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly {
    override val arn: Optional[MulticastGroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupArn(value)
      )
    override val id: Optional[MulticastGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastGroupId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateMulticastGroupResponse
  ): zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly =
    new Wrapper(impl)
}
