package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ClientRequestToken,
  DeviceProfileName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeviceProfileRequest(
    name: Optional[DeviceProfileName] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotwireless.model.Tag]] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkCreateDeviceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest = {
    import CreateDeviceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
      .builder()
      .optionallyWith(
        name.map(value => DeviceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.CreateDeviceProfileRequest.wrap(buildAwsValue())
}
object CreateDeviceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateDeviceProfileRequest =
      zio.aws.iotwireless.model.CreateDeviceProfileRequest(
        name.map(value => value),
        loRaWAN.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        sidewalk.map(value => value.asEditable)
      )
    def name: Optional[DeviceProfileName]
    def loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly]
    def tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkCreateDeviceProfile.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, DeviceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkCreateDeviceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ) extends zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly {
    override val name: Optional[DeviceProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileName(value)
      )
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDeviceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANDeviceProfile.wrap(value)
        )
    override val tags: Optional[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
        )
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkCreateDeviceProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkCreateDeviceProfile.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateDeviceProfileRequest
  ): zio.aws.iotwireless.model.CreateDeviceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
