package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ThingArn, WirelessGatewayId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateWirelessGatewayWithThingRequest(
    id: WirelessGatewayId,
    thingArn: ThingArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest = {
    import AssociateWirelessGatewayWithThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .thingArn(ThingArn.unwrap(thingArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest
      .wrap(buildAwsValue())
}
object AssociateWirelessGatewayWithThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest =
      zio.aws.iotwireless.model
        .AssociateWirelessGatewayWithThingRequest(id, thingArn)
    def id: WirelessGatewayId
    def thingArn: ThingArn
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
    def getThingArn: ZIO[Any, Nothing, ThingArn] = ZIO.succeed(thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest
  ) extends zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
    override val thingArn: ThingArn =
      zio.aws.iotwireless.model.primitives.ThingArn(impl.thingArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithThingRequest
  ): zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest.ReadOnly =
    new Wrapper(impl)
}
