package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessDeviceIdType {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType
}
object WirelessDeviceIdType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType
  ): zio.aws.iotwireless.model.WirelessDeviceIdType = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.WIRELESS_DEVICE_ID =>
      val r = WirelessDeviceId
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.DEV_EUI =>
      val r = DevEui
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.THING_NAME =>
      val r = ThingName
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.SIDEWALK_MANUFACTURING_SN =>
      val r = SidewalkManufacturingSn
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessDeviceIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.UNKNOWN_TO_SDK_VERSION
  }
  case object WirelessDeviceId
      extends zio.aws.iotwireless.model.WirelessDeviceIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.WIRELESS_DEVICE_ID
  }
  case object DevEui extends zio.aws.iotwireless.model.WirelessDeviceIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.DEV_EUI
  }
  case object ThingName extends zio.aws.iotwireless.model.WirelessDeviceIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.THING_NAME
  }
  case object SidewalkManufacturingSn
      extends zio.aws.iotwireless.model.WirelessDeviceIdType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType =
      software.amazon.awssdk.services.iotwireless.model.WirelessDeviceIdType.SIDEWALK_MANUFACTURING_SN
  }
}
