package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMulticastGroupSessionRequest(
    id: MulticastGroupId,
    loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticastSession
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest = {
    import StartMulticastGroupSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .loRaWAN(loRaWAN.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.StartMulticastGroupSessionRequest.ReadOnly =
    zio.aws.iotwireless.model.StartMulticastGroupSessionRequest
      .wrap(buildAwsValue())
}
object StartMulticastGroupSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.StartMulticastGroupSessionRequest =
      zio.aws.iotwireless.model
        .StartMulticastGroupSessionRequest(id, loRaWAN.asEditable)
    def id: MulticastGroupId
    def loRaWAN: zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getLoRaWAN: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly
    ] = ZIO.succeed(loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest
  ) extends zio.aws.iotwireless.model.StartMulticastGroupSessionRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val loRaWAN
        : zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly =
      zio.aws.iotwireless.model.LoRaWANMulticastSession.wrap(impl.loRaWAN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.StartMulticastGroupSessionRequest
  ): zio.aws.iotwireless.model.StartMulticastGroupSessionRequest.ReadOnly =
    new Wrapper(impl)
}
