package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DeviceProfileId,
  SidewalkManufacturingSn,
  SidewalkId,
  AmazonId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SidewalkListDevice(
    amazonId: Optional[AmazonId] = Optional.Absent,
    sidewalkId: Optional[SidewalkId] = Optional.Absent,
    sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      Optional.Absent,
    deviceCertificates: Optional[
      Iterable[zio.aws.iotwireless.model.CertificateList]
    ] = Optional.Absent,
    deviceProfileId: Optional[DeviceProfileId] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice = {
    import SidewalkListDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        sidewalkId.map(value => SidewalkId.unwrap(value): java.lang.String)
      )(_.sidewalkId)
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .optionallyWith(
        deviceCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceCertificates)
      .optionallyWith(
        deviceProfileId.map(value =>
          DeviceProfileId.unwrap(value): java.lang.String
        )
      )(_.deviceProfileId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly =
    zio.aws.iotwireless.model.SidewalkListDevice.wrap(buildAwsValue())
}
object SidewalkListDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkListDevice =
      zio.aws.iotwireless.model.SidewalkListDevice(
        amazonId.map(value => value),
        sidewalkId.map(value => value),
        sidewalkManufacturingSn.map(value => value),
        deviceCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deviceProfileId.map(value => value),
        status.map(value => value)
      )
    def amazonId: Optional[AmazonId]
    def sidewalkId: Optional[SidewalkId]
    def sidewalkManufacturingSn: Optional[SidewalkManufacturingSn]
    def deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]]
    def deviceProfileId: Optional[DeviceProfileId]
    def status: Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getSidewalkId: ZIO[Any, AwsError, SidewalkId] =
      AwsError.unwrapOptionField("sidewalkId", sidewalkId)
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
    def getDeviceCertificates: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.CertificateList.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceCertificates", deviceCertificates)
    def getDeviceProfileId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("deviceProfileId", deviceProfileId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ) extends zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly {
    override val amazonId: Optional[AmazonId] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val sidewalkId: Optional[SidewalkId] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalkId())
      .map(value => zio.aws.iotwireless.model.primitives.SidewalkId(value))
    override val sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
    override val deviceCertificates
        : Optional[List[zio.aws.iotwireless.model.CertificateList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.CertificateList.wrap(item)
          }.toList
        )
    override val deviceProfileId: Optional[DeviceProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceProfileId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DeviceProfileId(value)
        )
    override val status
        : Optional[zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotwireless.model.WirelessDeviceSidewalkStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice
  ): zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly = new Wrapper(impl)
}
