package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupMessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendDataToMulticastGroupResponse(
    messageId: Optional[MulticastGroupMessageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse = {
    import SendDataToMulticastGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse
      .builder()
      .optionallyWith(
        messageId.map(value =>
          MulticastGroupMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly =
    zio.aws.iotwireless.model.SendDataToMulticastGroupResponse
      .wrap(buildAwsValue())
}
object SendDataToMulticastGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SendDataToMulticastGroupResponse =
      zio.aws.iotwireless.model
        .SendDataToMulticastGroupResponse(messageId.map(value => value))
    def messageId: Optional[MulticastGroupMessageId]
    def getMessageId: ZIO[Any, AwsError, MulticastGroupMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse
  ) extends zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly {
    override val messageId: Optional[MulticastGroupMessageId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.MulticastGroupMessageId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupResponse
  ): zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly =
    new Wrapper(impl)
}
