package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{PayloadData, MulticastGroupId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendDataToMulticastGroupRequest(
    id: MulticastGroupId,
    payloadData: PayloadData,
    wirelessMetadata: zio.aws.iotwireless.model.MulticastWirelessMetadata
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest = {
    import SendDataToMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .payloadData(PayloadData.unwrap(payloadData): java.lang.String)
      .wirelessMetadata(wirelessMetadata.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SendDataToMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.SendDataToMulticastGroupRequest
      .wrap(buildAwsValue())
}
object SendDataToMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SendDataToMulticastGroupRequest =
      zio.aws.iotwireless.model.SendDataToMulticastGroupRequest(
        id,
        payloadData,
        wirelessMetadata.asEditable
      )
    def id: MulticastGroupId
    def payloadData: PayloadData
    def wirelessMetadata
        : zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
    def getPayloadData: ZIO[Any, Nothing, PayloadData] =
      ZIO.succeed(payloadData)
    def getWirelessMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly
    ] = ZIO.succeed(wirelessMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.SendDataToMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
    override val payloadData: PayloadData =
      zio.aws.iotwireless.model.primitives.PayloadData(impl.payloadData())
    override val wirelessMetadata
        : zio.aws.iotwireless.model.MulticastWirelessMetadata.ReadOnly =
      zio.aws.iotwireless.model.MulticastWirelessMetadata
        .wrap(impl.wirelessMetadata())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SendDataToMulticastGroupRequest
  ): zio.aws.iotwireless.model.SendDataToMulticastGroupRequest.ReadOnly =
    new Wrapper(impl)
}
