package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait OnboardStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.OnboardStatus
}
object OnboardStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.OnboardStatus
  ): zio.aws.iotwireless.model.OnboardStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.OnboardStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.OnboardStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.iotwireless.model.OnboardStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.iotwireless.model.OnboardStatus.ONBOARDED =>
      val r = ONBOARDED
      r
    case software.amazon.awssdk.services.iotwireless.model.OnboardStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.OnboardStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.OnboardStatus =
      software.amazon.awssdk.services.iotwireless.model.OnboardStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.iotwireless.model.OnboardStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.OnboardStatus =
      software.amazon.awssdk.services.iotwireless.model.OnboardStatus.INITIALIZED
  }
  case object PENDING extends zio.aws.iotwireless.model.OnboardStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.OnboardStatus =
      software.amazon.awssdk.services.iotwireless.model.OnboardStatus.PENDING
  }
  case object ONBOARDED extends zio.aws.iotwireless.model.OnboardStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.OnboardStatus =
      software.amazon.awssdk.services.iotwireless.model.OnboardStatus.ONBOARDED
  }
  case object FAILED extends zio.aws.iotwireless.model.OnboardStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.OnboardStatus =
      software.amazon.awssdk.services.iotwireless.model.OnboardStatus.FAILED
  }
}
