package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MessageDeliveryStatusEventConfiguration(
    sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
    ] = Optional.Absent,
    wirelessDeviceIdEventTopic: Optional[
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration = {
    import MessageDeliveryStatusEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(wirelessDeviceIdEventTopic.map(value => value.unwrap))(
        _.wirelessDeviceIdEventTopic
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration
      .wrap(buildAwsValue())
}
object MessageDeliveryStatusEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration =
      zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration(
        sidewalk.map(value => value.asEditable),
        wirelessDeviceIdEventTopic.map(value => value)
      )
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ]
    def wirelessDeviceIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getWirelessDeviceIdEventTopic: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationTopicStatus
    ] = AwsError.unwrapOptionField(
      "wirelessDeviceIdEventTopic",
      wirelessDeviceIdEventTopic
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
  ) extends zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly {
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
          .wrap(value)
      )
    override val wirelessDeviceIdEventTopic
        : Optional[zio.aws.iotwireless.model.EventNotificationTopicStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessDeviceIdEventTopic())
        .map(value =>
          zio.aws.iotwireless.model.EventNotificationTopicStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.MessageDeliveryStatusEventConfiguration
  ): zio.aws.iotwireless.model.MessageDeliveryStatusEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
