package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  NRCapable,
  RSRQ,
  EutranCid,
  MCC,
  TAC,
  RSRP,
  LteTimingAdvance,
  MNC
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LteObj(
    mcc: MCC,
    mnc: MNC,
    eutranCid: EutranCid,
    tac: Optional[TAC] = Optional.Absent,
    lteLocalId: Optional[zio.aws.iotwireless.model.LteLocalId] =
      Optional.Absent,
    lteTimingAdvance: Optional[LteTimingAdvance] = Optional.Absent,
    rsrp: Optional[RSRP] = Optional.Absent,
    rsrq: Optional[RSRQ] = Optional.Absent,
    nrCapable: Optional[NRCapable] = Optional.Absent,
    lteNmr: Optional[Iterable[zio.aws.iotwireless.model.LteNmrObj]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LteObj = {
    import LteObj.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LteObj
      .builder()
      .mcc(MCC.unwrap(mcc): Integer)
      .mnc(MNC.unwrap(mnc): Integer)
      .eutranCid(EutranCid.unwrap(eutranCid): Integer)
      .optionallyWith(tac.map(value => TAC.unwrap(value): Integer))(_.tac)
      .optionallyWith(lteLocalId.map(value => value.buildAwsValue()))(
        _.lteLocalId
      )
      .optionallyWith(
        lteTimingAdvance.map(value => LteTimingAdvance.unwrap(value): Integer)
      )(_.lteTimingAdvance)
      .optionallyWith(rsrp.map(value => RSRP.unwrap(value): Integer))(_.rsrp)
      .optionallyWith(rsrq.map(value => RSRQ.unwrap(value): java.lang.Float))(
        _.rsrq
      )
      .optionallyWith(
        nrCapable.map(value => NRCapable.unwrap(value): java.lang.Boolean)
      )(_.nrCapable)
      .optionallyWith(
        lteNmr.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lteNmr)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LteObj.ReadOnly =
    zio.aws.iotwireless.model.LteObj.wrap(buildAwsValue())
}
object LteObj {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LteObj
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LteObj =
      zio.aws.iotwireless.model.LteObj(
        mcc,
        mnc,
        eutranCid,
        tac.map(value => value),
        lteLocalId.map(value => value.asEditable),
        lteTimingAdvance.map(value => value),
        rsrp.map(value => value),
        rsrq.map(value => value),
        nrCapable.map(value => value),
        lteNmr.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def mcc: MCC
    def mnc: MNC
    def eutranCid: EutranCid
    def tac: Optional[TAC]
    def lteLocalId: Optional[zio.aws.iotwireless.model.LteLocalId.ReadOnly]
    def lteTimingAdvance: Optional[LteTimingAdvance]
    def rsrp: Optional[RSRP]
    def rsrq: Optional[RSRQ]
    def nrCapable: Optional[NRCapable]
    def lteNmr: Optional[List[zio.aws.iotwireless.model.LteNmrObj.ReadOnly]]
    def getMcc: ZIO[Any, Nothing, MCC] = ZIO.succeed(mcc)
    def getMnc: ZIO[Any, Nothing, MNC] = ZIO.succeed(mnc)
    def getEutranCid: ZIO[Any, Nothing, EutranCid] = ZIO.succeed(eutranCid)
    def getTac: ZIO[Any, AwsError, TAC] = AwsError.unwrapOptionField("tac", tac)
    def getLteLocalId
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LteLocalId.ReadOnly] =
      AwsError.unwrapOptionField("lteLocalId", lteLocalId)
    def getLteTimingAdvance: ZIO[Any, AwsError, LteTimingAdvance] =
      AwsError.unwrapOptionField("lteTimingAdvance", lteTimingAdvance)
    def getRsrp: ZIO[Any, AwsError, RSRP] =
      AwsError.unwrapOptionField("rsrp", rsrp)
    def getRsrq: ZIO[Any, AwsError, RSRQ] =
      AwsError.unwrapOptionField("rsrq", rsrq)
    def getNrCapable: ZIO[Any, AwsError, NRCapable] =
      AwsError.unwrapOptionField("nrCapable", nrCapable)
    def getLteNmr: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.LteNmrObj.ReadOnly
    ]] = AwsError.unwrapOptionField("lteNmr", lteNmr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LteObj
  ) extends zio.aws.iotwireless.model.LteObj.ReadOnly {
    override val mcc: MCC = zio.aws.iotwireless.model.primitives.MCC(impl.mcc())
    override val mnc: MNC = zio.aws.iotwireless.model.primitives.MNC(impl.mnc())
    override val eutranCid: EutranCid =
      zio.aws.iotwireless.model.primitives.EutranCid(impl.eutranCid())
    override val tac: Optional[TAC] = zio.aws.core.internal
      .optionalFromNullable(impl.tac())
      .map(value => zio.aws.iotwireless.model.primitives.TAC(value))
    override val lteLocalId
        : Optional[zio.aws.iotwireless.model.LteLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lteLocalId())
        .map(value => zio.aws.iotwireless.model.LteLocalId.wrap(value))
    override val lteTimingAdvance: Optional[LteTimingAdvance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lteTimingAdvance())
        .map(value =>
          zio.aws.iotwireless.model.primitives.LteTimingAdvance(value)
        )
    override val rsrp: Optional[RSRP] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrp())
      .map(value => zio.aws.iotwireless.model.primitives.RSRP(value))
    override val rsrq: Optional[RSRQ] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrq())
      .map(value => zio.aws.iotwireless.model.primitives.RSRQ(value))
    override val nrCapable: Optional[NRCapable] = zio.aws.core.internal
      .optionalFromNullable(impl.nrCapable())
      .map(value => zio.aws.iotwireless.model.primitives.NRCapable(value))
    override val lteNmr
        : Optional[List[zio.aws.iotwireless.model.LteNmrObj.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lteNmr())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.LteNmrObj.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LteObj
  ): zio.aws.iotwireless.model.LteObj.ReadOnly = new Wrapper(impl)
}
