package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.StartTime
import scala.jdk.CollectionConverters._
final case class LoRaWANStartFuotaTask(
    startTime: Optional[StartTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANStartFuotaTask = {
    import LoRaWANStartFuotaTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANStartFuotaTask
      .builder()
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANStartFuotaTask.wrap(buildAwsValue())
}
object LoRaWANStartFuotaTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANStartFuotaTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANStartFuotaTask =
      zio.aws.iotwireless.model
        .LoRaWANStartFuotaTask(startTime.map(value => value))
    def startTime: Optional[StartTime]
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANStartFuotaTask
  ) extends zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly {
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotwireless.model.primitives.StartTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANStartFuotaTask
  ): zio.aws.iotwireless.model.LoRaWANStartFuotaTask.ReadOnly = new Wrapper(
    impl
  )
}
