package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPartnerAccountsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    sidewalk: Optional[
      Iterable[zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse = {
    import ListPartnerAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sidewalk.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListPartnerAccountsResponse.wrap(buildAwsValue())
}
object ListPartnerAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListPartnerAccountsResponse =
      zio.aws.iotwireless.model.ListPartnerAccountsResponse(
        nextToken.map(value => value),
        sidewalk.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def sidewalk: Optional[List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSidewalk: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ) extends zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val sidewalk: Optional[List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ): zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
