package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  LastUpdateTime,
  OnboardStatusReason,
  SidewalkManufacturingSn
}
import scala.jdk.CollectionConverters._
final case class ImportedSidewalkDevice(
    sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      Optional.Absent,
    onboardingStatus: Optional[zio.aws.iotwireless.model.OnboardStatus] =
      Optional.Absent,
    onboardingStatusReason: Optional[OnboardStatusReason] = Optional.Absent,
    lastUpdateTime: Optional[LastUpdateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ImportedSidewalkDevice = {
    import ImportedSidewalkDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ImportedSidewalkDevice
      .builder()
      .optionallyWith(
        sidewalkManufacturingSn.map(value =>
          SidewalkManufacturingSn.unwrap(value): java.lang.String
        )
      )(_.sidewalkManufacturingSn)
      .optionallyWith(onboardingStatus.map(value => value.unwrap))(
        _.onboardingStatus
      )
      .optionallyWith(
        onboardingStatusReason.map(value =>
          OnboardStatusReason.unwrap(value): java.lang.String
        )
      )(_.onboardingStatusReason)
      .optionallyWith(
        lastUpdateTime.map(value => LastUpdateTime.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly =
    zio.aws.iotwireless.model.ImportedSidewalkDevice.wrap(buildAwsValue())
}
object ImportedSidewalkDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ImportedSidewalkDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ImportedSidewalkDevice =
      zio.aws.iotwireless.model.ImportedSidewalkDevice(
        sidewalkManufacturingSn.map(value => value),
        onboardingStatus.map(value => value),
        onboardingStatusReason.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def sidewalkManufacturingSn: Optional[SidewalkManufacturingSn]
    def onboardingStatus: Optional[zio.aws.iotwireless.model.OnboardStatus]
    def onboardingStatusReason: Optional[OnboardStatusReason]
    def lastUpdateTime: Optional[LastUpdateTime]
    def getSidewalkManufacturingSn
        : ZIO[Any, AwsError, SidewalkManufacturingSn] = AwsError
      .unwrapOptionField("sidewalkManufacturingSn", sidewalkManufacturingSn)
    def getOnboardingStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.OnboardStatus] =
      AwsError.unwrapOptionField("onboardingStatus", onboardingStatus)
    def getOnboardingStatusReason: ZIO[Any, AwsError, OnboardStatusReason] =
      AwsError.unwrapOptionField(
        "onboardingStatusReason",
        onboardingStatusReason
      )
    def getLastUpdateTime: ZIO[Any, AwsError, LastUpdateTime] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ImportedSidewalkDevice
  ) extends zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly {
    override val sidewalkManufacturingSn: Optional[SidewalkManufacturingSn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalkManufacturingSn())
        .map(value =>
          zio.aws.iotwireless.model.primitives.SidewalkManufacturingSn(value)
        )
    override val onboardingStatus
        : Optional[zio.aws.iotwireless.model.OnboardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onboardingStatus())
        .map(value => zio.aws.iotwireless.model.OnboardStatus.wrap(value))
    override val onboardingStatusReason: Optional[OnboardStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onboardingStatusReason())
        .map(value =>
          zio.aws.iotwireless.model.primitives.OnboardStatusReason(value)
        )
    override val lastUpdateTime: Optional[LastUpdateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTime())
        .map(value =>
          zio.aws.iotwireless.model.primitives.LastUpdateTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ImportedSidewalkDevice
  ): zio.aws.iotwireless.model.ImportedSidewalkDevice.ReadOnly = new Wrapper(
    impl
  )
}
