package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  WirelessGatewayTaskDefinitionId,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskResponse(
    wirelessGatewayId: Optional[WirelessGatewayId] = Optional.Absent,
    wirelessGatewayTaskDefinitionId: Optional[WirelessGatewayTaskDefinitionId] =
      Optional.Absent,
    lastUplinkReceivedAt: Optional[ISODateTimeString] = Optional.Absent,
    taskCreatedAt: Optional[ISODateTimeString] = Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse = {
    import GetWirelessGatewayTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
      .builder()
      .optionallyWith(
        wirelessGatewayId.map(value =>
          WirelessGatewayId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayId)
      .optionallyWith(
        wirelessGatewayTaskDefinitionId.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayTaskDefinitionId)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(
        taskCreatedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.taskCreatedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse(
        wirelessGatewayId.map(value => value),
        wirelessGatewayTaskDefinitionId.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        taskCreatedAt.map(value => value),
        status.map(value => value)
      )
    def wirelessGatewayId: Optional[WirelessGatewayId]
    def wirelessGatewayTaskDefinitionId
        : Optional[WirelessGatewayTaskDefinitionId]
    def lastUplinkReceivedAt: Optional[ISODateTimeString]
    def taskCreatedAt: Optional[ISODateTimeString]
    def status: Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus]
    def getWirelessGatewayId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("wirelessGatewayId", wirelessGatewayId)
    def getWirelessGatewayTaskDefinitionId
        : ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField(
        "wirelessGatewayTaskDefinitionId",
        wirelessGatewayTaskDefinitionId
      )
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getTaskCreatedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("taskCreatedAt", taskCreatedAt)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayTaskStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly {
    override val wirelessGatewayId: Optional[WirelessGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wirelessGatewayId())
        .map(value =>
          zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
        )
    override val wirelessGatewayTaskDefinitionId
        : Optional[WirelessGatewayTaskDefinitionId] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessGatewayTaskDefinitionId())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionId(value)
      )
    override val lastUplinkReceivedAt: Optional[ISODateTimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUplinkReceivedAt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
        )
    override val taskCreatedAt: Optional[ISODateTimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskCreatedAt())
        .map(value =>
          zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
        )
    override val status
        : Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotwireless.model.WirelessGatewayTaskStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly =
    new Wrapper(impl)
}
