package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ThingName,
  ThingArn,
  WirelessDeviceName,
  Description,
  WirelessDeviceId,
  WirelessDeviceArn,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceResponse(
    `type`: Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      Optional.Absent,
    name: Optional[WirelessDeviceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    destinationName: Optional[DestinationName] = Optional.Absent,
    id: Optional[WirelessDeviceId] = Optional.Absent,
    arn: Optional[WirelessDeviceArn] = Optional.Absent,
    thingName: Optional[ThingName] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDevice] =
      Optional.Absent,
    sidewalk: Optional[zio.aws.iotwireless.model.SidewalkDevice] =
      Optional.Absent,
    positioning: Optional[zio.aws.iotwireless.model.PositioningConfigStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse = {
    import GetWirelessDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => WirelessDeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(positioning.map(value => value.unwrap))(_.positioning)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceResponse.wrap(buildAwsValue())
}
object GetWirelessDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessDeviceResponse =
      zio.aws.iotwireless.model.GetWirelessDeviceResponse(
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        destinationName.map(value => value),
        id.map(value => value),
        arn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable),
        positioning.map(value => value)
      )
    def `type`: Optional[zio.aws.iotwireless.model.WirelessDeviceType]
    def name: Optional[WirelessDeviceName]
    def description: Optional[Description]
    def destinationName: Optional[DestinationName]
    def id: Optional[WirelessDeviceId]
    def arn: Optional[WirelessDeviceArn]
    def thingName: Optional[ThingName]
    def thingArn: Optional[ThingArn]
    def loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly]
    def sidewalk: Optional[zio.aws.iotwireless.model.SidewalkDevice.ReadOnly]
    def positioning: Optional[zio.aws.iotwireless.model.PositioningConfigStatus]
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, WirelessDeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getLoRaWAN
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getPositioning: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.PositioningConfigStatus
    ] = AwsError.unwrapOptionField("positioning", positioning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly {
    override val `type`
        : Optional[zio.aws.iotwireless.model.WirelessDeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val name: Optional[WirelessDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val destinationName: Optional[DestinationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationName())
        .map(value =>
          zio.aws.iotwireless.model.primitives.DestinationName(value)
        )
    override val id: Optional[WirelessDeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
    override val arn: Optional[WirelessDeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceArn(value)
      )
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iotwireless.model.primitives.ThingName(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iotwireless.model.primitives.ThingArn(value))
    override val loRaWAN
        : Optional[zio.aws.iotwireless.model.LoRaWANDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loRaWAN())
        .map(value => zio.aws.iotwireless.model.LoRaWANDevice.wrap(value))
    override val sidewalk
        : Optional[zio.aws.iotwireless.model.SidewalkDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sidewalk())
        .map(value => zio.aws.iotwireless.model.SidewalkDevice.wrap(value))
    override val positioning
        : Optional[zio.aws.iotwireless.model.PositioningConfigStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positioning())
        .map(value =>
          zio.aws.iotwireless.model.PositioningConfigStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceResponse
  ): zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
