package zio.aws.iotwireless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.CreationDate
import scala.jdk.CollectionConverters._
final case class GetPositionEstimateRequest(
    wiFiAccessPoints: Optional[
      Iterable[zio.aws.iotwireless.model.WiFiAccessPoint]
    ] = Optional.Absent,
    cellTowers: Optional[zio.aws.iotwireless.model.CellTowers] =
      Optional.Absent,
    ip: Optional[zio.aws.iotwireless.model.Ip] = Optional.Absent,
    gnss: Optional[zio.aws.iotwireless.model.Gnss] = Optional.Absent,
    timestamp: Optional[CreationDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest = {
    import GetPositionEstimateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest
      .builder()
      .optionallyWith(
        wiFiAccessPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wiFiAccessPoints)
      .optionallyWith(cellTowers.map(value => value.buildAwsValue()))(
        _.cellTowers
      )
      .optionallyWith(ip.map(value => value.buildAwsValue()))(_.ip)
      .optionallyWith(gnss.map(value => value.buildAwsValue()))(_.gnss)
      .optionallyWith(
        timestamp.map(value => CreationDate.unwrap(value): Instant)
      )(_.timestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetPositionEstimateRequest.ReadOnly =
    zio.aws.iotwireless.model.GetPositionEstimateRequest.wrap(buildAwsValue())
}
object GetPositionEstimateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPositionEstimateRequest =
      zio.aws.iotwireless.model.GetPositionEstimateRequest(
        wiFiAccessPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cellTowers.map(value => value.asEditable),
        ip.map(value => value.asEditable),
        gnss.map(value => value.asEditable),
        timestamp.map(value => value)
      )
    def wiFiAccessPoints
        : Optional[List[zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly]]
    def cellTowers: Optional[zio.aws.iotwireless.model.CellTowers.ReadOnly]
    def ip: Optional[zio.aws.iotwireless.model.Ip.ReadOnly]
    def gnss: Optional[zio.aws.iotwireless.model.Gnss.ReadOnly]
    def timestamp: Optional[CreationDate]
    def getWiFiAccessPoints: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("wiFiAccessPoints", wiFiAccessPoints)
    def getCellTowers
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.CellTowers.ReadOnly] =
      AwsError.unwrapOptionField("cellTowers", cellTowers)
    def getIp: ZIO[Any, AwsError, zio.aws.iotwireless.model.Ip.ReadOnly] =
      AwsError.unwrapOptionField("ip", ip)
    def getGnss: ZIO[Any, AwsError, zio.aws.iotwireless.model.Gnss.ReadOnly] =
      AwsError.unwrapOptionField("gnss", gnss)
    def getTimestamp: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest
  ) extends zio.aws.iotwireless.model.GetPositionEstimateRequest.ReadOnly {
    override val wiFiAccessPoints
        : Optional[List[zio.aws.iotwireless.model.WiFiAccessPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wiFiAccessPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.WiFiAccessPoint.wrap(item)
          }.toList
        )
    override val cellTowers
        : Optional[zio.aws.iotwireless.model.CellTowers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cellTowers())
        .map(value => zio.aws.iotwireless.model.CellTowers.wrap(value))
    override val ip: Optional[zio.aws.iotwireless.model.Ip.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ip())
        .map(value => zio.aws.iotwireless.model.Ip.wrap(value))
    override val gnss: Optional[zio.aws.iotwireless.model.Gnss.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gnss())
        .map(value => zio.aws.iotwireless.model.Gnss.wrap(value))
    override val timestamp: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.iotwireless.model.primitives.CreationDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPositionEstimateRequest
  ): zio.aws.iotwireless.model.GetPositionEstimateRequest.ReadOnly =
    new Wrapper(impl)
}
