package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  DownlinkFrequency,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GatewayListItem(
    gatewayId: WirelessGatewayId,
    downlinkFrequency: DownlinkFrequency
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GatewayListItem = {
    import GatewayListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GatewayListItem
      .builder()
      .gatewayId(WirelessGatewayId.unwrap(gatewayId): java.lang.String)
      .downlinkFrequency(DownlinkFrequency.unwrap(downlinkFrequency): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GatewayListItem.ReadOnly =
    zio.aws.iotwireless.model.GatewayListItem.wrap(buildAwsValue())
}
object GatewayListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GatewayListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GatewayListItem =
      zio.aws.iotwireless.model.GatewayListItem(gatewayId, downlinkFrequency)
    def gatewayId: WirelessGatewayId
    def downlinkFrequency: DownlinkFrequency
    def getGatewayId: ZIO[Any, Nothing, WirelessGatewayId] =
      ZIO.succeed(gatewayId)
    def getDownlinkFrequency: ZIO[Any, Nothing, DownlinkFrequency] =
      ZIO.succeed(downlinkFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GatewayListItem
  ) extends zio.aws.iotwireless.model.GatewayListItem.ReadOnly {
    override val gatewayId: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.gatewayId())
    override val downlinkFrequency: DownlinkFrequency =
      zio.aws.iotwireless.model.primitives
        .DownlinkFrequency(impl.downlinkFrequency())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GatewayListItem
  ): zio.aws.iotwireless.model.GatewayListItem.ReadOnly = new Wrapper(impl)
}
