package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.FuotaTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFuotaTaskRequest(id: FuotaTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest = {
    import DeleteFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.DeleteFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteFuotaTaskRequest.wrap(buildAwsValue())
}
object DeleteFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteFuotaTaskRequest =
      zio.aws.iotwireless.model.DeleteFuotaTaskRequest(id)
    def id: FuotaTaskId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.DeleteFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteFuotaTaskRequest
  ): zio.aws.iotwireless.model.DeleteFuotaTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
