package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  FactorySupport,
  MaxAllowedSignature,
  DakCertificateId,
  DeviceTypeId,
  ApId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DakCertificateMetadata(
    certificateId: DakCertificateId,
    maxAllowedSignature: Optional[MaxAllowedSignature] = Optional.Absent,
    factorySupport: Optional[FactorySupport] = Optional.Absent,
    apId: Optional[ApId] = Optional.Absent,
    deviceTypeId: Optional[DeviceTypeId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata = {
    import DakCertificateMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata
      .builder()
      .certificateId(DakCertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(
        maxAllowedSignature.map(value =>
          MaxAllowedSignature.unwrap(value): Integer
        )
      )(_.maxAllowedSignature)
      .optionallyWith(
        factorySupport.map(value =>
          FactorySupport.unwrap(value): java.lang.Boolean
        )
      )(_.factorySupport)
      .optionallyWith(apId.map(value => ApId.unwrap(value): java.lang.String))(
        _.apId
      )
      .optionallyWith(
        deviceTypeId.map(value => DeviceTypeId.unwrap(value): java.lang.String)
      )(_.deviceTypeId)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly =
    zio.aws.iotwireless.model.DakCertificateMetadata.wrap(buildAwsValue())
}
object DakCertificateMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DakCertificateMetadata =
      zio.aws.iotwireless.model.DakCertificateMetadata(
        certificateId,
        maxAllowedSignature.map(value => value),
        factorySupport.map(value => value),
        apId.map(value => value),
        deviceTypeId.map(value => value)
      )
    def certificateId: DakCertificateId
    def maxAllowedSignature: Optional[MaxAllowedSignature]
    def factorySupport: Optional[FactorySupport]
    def apId: Optional[ApId]
    def deviceTypeId: Optional[DeviceTypeId]
    def getCertificateId: ZIO[Any, Nothing, DakCertificateId] =
      ZIO.succeed(certificateId)
    def getMaxAllowedSignature: ZIO[Any, AwsError, MaxAllowedSignature] =
      AwsError.unwrapOptionField("maxAllowedSignature", maxAllowedSignature)
    def getFactorySupport: ZIO[Any, AwsError, FactorySupport] =
      AwsError.unwrapOptionField("factorySupport", factorySupport)
    def getApId: ZIO[Any, AwsError, ApId] =
      AwsError.unwrapOptionField("apId", apId)
    def getDeviceTypeId: ZIO[Any, AwsError, DeviceTypeId] =
      AwsError.unwrapOptionField("deviceTypeId", deviceTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata
  ) extends zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly {
    override val certificateId: DakCertificateId =
      zio.aws.iotwireless.model.primitives
        .DakCertificateId(impl.certificateId())
    override val maxAllowedSignature: Optional[MaxAllowedSignature] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllowedSignature())
        .map(value =>
          zio.aws.iotwireless.model.primitives.MaxAllowedSignature(value)
        )
    override val factorySupport: Optional[FactorySupport] =
      zio.aws.core.internal
        .optionalFromNullable(impl.factorySupport())
        .map(value =>
          zio.aws.iotwireless.model.primitives.FactorySupport(value)
        )
    override val apId: Optional[ApId] = zio.aws.core.internal
      .optionalFromNullable(impl.apId())
      .map(value => zio.aws.iotwireless.model.primitives.ApId(value))
    override val deviceTypeId: Optional[DeviceTypeId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceTypeId())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceTypeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata
  ): zio.aws.iotwireless.model.DakCertificateMetadata.ReadOnly = new Wrapper(
    impl
  )
}
